/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.entity.EntityManaBurst;

public class BlockPool
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape REAL_SHAPE;
    private static final VoxelShape BURST_SHAPE;
    public final Variant variant;

    public BlockPool(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, world, tooltip, flag);
        if (this.variant == Variant.CREATIVE) {
            for (int i = 0; i < 2; ++i) {
                tooltip.add((Component)new TranslatableComponent("botaniamisc.creativePool" + i).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return REAL_SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity te = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (te instanceof TilePool) {
                TilePool pool = (TilePool)te;
                DyeColor color = dye.m_41089_();
                if (color != pool.getColor()) {
                    pool.setColor(color);
                    stack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext econtext;
        if (context instanceof EntityCollisionContext && (econtext = (EntityCollisionContext)context).m_193113_() instanceof EntityManaBurst) {
            return BURST_SHAPE;
        }
        return super.m_5939_(state, world, pos, context);
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TilePool(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockPool.createTickerHelper(type, ModTiles.POOL, level.f_46443_ ? TilePool::clientTick : TilePool::serverTick);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            TilePool tile = (TilePool)world.m_7702_(pos);
            tile.collideEntityItem(item);
        }
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        if (this.variant == Variant.FABULOUS) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        TilePool pool = (TilePool)world.m_7702_(pos);
        return TilePool.calculateComparatorLevel(pool.getCurrentMana(), pool.manaCap);
    }

    static {
        VoxelShape slab = BlockPool.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape cutout = BlockPool.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        VoxelShape cutoutBurst = BlockPool.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        BURST_SHAPE = Shapes.m_83113_((VoxelShape)slab, (VoxelShape)cutoutBurst, (BooleanOp)BooleanOp.f_82685_);
        REAL_SHAPE = Shapes.m_83113_((VoxelShape)slab, (VoxelShape)cutout, (BooleanOp)BooleanOp.f_82685_);
    }

    public static enum Variant {
        DEFAULT,
        CREATIVE,
        DILUTED,
        FABULOUS;

    }
}

